<?php

namespace Drupal\viewer\Plugin;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * ViewerCell plugin base class.
 */
class ViewerCellBase extends PluginBase implements ViewerCellInterface {

  /**
   * {@inheritdoc}
   */
  public function getName(): TranslatableMarkup|string|null {
    return $this->pluginDefinition['name'] ?? NULL;
  }

  /**
   * Get applicable viewers.
   *
   * @return array
   *   Array of applicable viewer plugin IDs.
   */
  public function getApplicableViewers(): array {
    return $this->pluginDefinition['viewers'] ?? [];
  }

  /**
   * {@inheritdoc}
   */
  public function convert(mixed $value, array $row): mixed {
    return $value;
  }

}
