<?php

namespace Drupal\viewer\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an interface ViewerCell plugins.
 */
interface ViewerCellInterface extends PluginInspectionInterface {

  /**
   * Return the name of the ViewerCell plugin.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|string|null
   *   The plugin name.
   */
  public function getName(): TranslatableMarkup|string|null;

  /**
   * Convert Viewer Cell value before output.
   *
   * @param mixed $value
   *   The cell value.
   * @param array $row
   *   The entire row data.
   *
   * @return mixed
   *   The converted value.
   */
  public function convert(mixed $value, array $row): mixed;

}
