<?php

namespace Drupal\viewer\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\viewer\Entity\Viewer;

/**
 * Defines an interface Viewer plugins.
 */
interface ViewerInterface extends PluginInspectionInterface {

  /**
   * Return the name of the Viewer plugin.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|string|null
   *   The plugin name.
   */
  public function getName(): TranslatableMarkup|string|null;

  /**
   * Sets the Viewer entity.
   *
   * @param \Drupal\viewer\Entity\Viewer $viewer
   *   The Viewer entity.
   *
   * @return $this
   *   The called Viewer plugin.
   */
  public function setViewer(Viewer $viewer): static;

  /**
   * Gets the Viewer entity.
   *
   * @return \Drupal\viewer\Entity\Viewer|null
   *   The Viewer entity.
   */
  public function getViewer(): ?Viewer;

}
