<?php

namespace Drupal\viewer\Plugin;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\viewer\Entity\ViewerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * ViewerProcessorBase plugin base class.
 */
class ViewerProcessorBase extends PluginBase implements ViewerProcessorInterface, ContainerFactoryPluginInterface {

  use DependencySerializationTrait;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public function getDataAsArray(ViewerInterface $viewer, bool $split_headers): array {
    return [];
  }

}
