<?php

namespace Drupal\viewer\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\viewer\Entity\ViewerInterface;

/**
 * Defines an interface ViewerProcessorInterface plugins.
 */
interface ViewerProcessorInterface extends PluginInspectionInterface {

  /**
   * Get data as array (for CSV, XLSX etc).
   *
   * @param \Drupal\viewer\Entity\ViewerInterface $viewer
   *   The viewer entity.
   * @param bool $split_headers
   *   Whether to split headers from rows.
   *
   * @return array
   *   The data as array.
   */
  public function getDataAsArray(ViewerInterface $viewer, bool $split_headers): array;

}
