<?php

namespace Drupal\viewer\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an interface ViewerSourceInterface plugins.
 */
interface ViewerSourceInterface extends PluginInspectionInterface {

  /**
   * Return the name of the ViewerSourceInterface plugin.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|string|null
   *   The plugin name.
   */
  public function getName(): TranslatableMarkup|string|null;

  /**
   * Build source upload form.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param mixed $viewer_type
   *   The viewer type plugin.
   * @param mixed $viewer_source
   *   The viewer source entity.
   *
   * @return array
   *   The form array.
   */
  public function sourceForm(array $form, FormStateInterface $form_state, mixed $viewer_type, mixed $viewer_source): array;

  /**
   * Process uploaded file.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param mixed $viewer_type
   *   The viewer type plugin.
   *
   * @return array|false
   *   The batch items or FALSE.
   */
  public function submitSourceForm(array &$form, FormStateInterface $form_state, mixed $viewer_type): array|false;

  /**
   * Build import data form.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param mixed $viewer_type
   *   The viewer type plugin.
   * @param mixed $viewer_source
   *   The viewer source entity.
   *
   * @return array
   *   The form array.
   */
  public function importForm(array $form, FormStateInterface $form_state, mixed $viewer_type, mixed $viewer_source): array;

  /**
   * Process uploaded file (import data).
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param mixed $viewer_source
   *   The viewer source entity.
   *
   * @return array|false
   *   The batch items or FALSE.
   */
  public function submitImportForm(array &$form, FormStateInterface $form_state, mixed $viewer_source = NULL): array|false;

}
