<?php

namespace Drupal\viewer\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an interface ViewerTypeInterface plugins.
 */
interface ViewerTypeInterface extends PluginInspectionInterface {

  /**
   * Return the name of the ViewerTypeInterface plugin.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|string|null
   *   The plugin name.
   */
  public function getName(): TranslatableMarkup|string|null;

  /**
   * Return list of extensions.
   *
   * @return array
   *   Array of extensions keyed by mime type.
   */
  public function getExtensions(): array;

  /**
   * Return list of extensions in a single array element.
   *
   * @return array
   *   Array with 'extensions' key containing space-separated extensions.
   */
  public function getExtensionsAsValidator(): array;

  /**
   * Check if requirements are met for this viewer type.
   *
   * @return bool
   *   TRUE if all requirements are met, FALSE otherwise.
   */
  public function requirementsMet(): bool;

}
