<?php

namespace Drupal\viewer\Plugin\viewer\cell;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\viewer\Attribute\ViewerCell;
use Drupal\viewer\Plugin\ViewerCellBase;

/**
 * Money ViewerCell cell plugin.
 */
#[ViewerCell(
  id: 'money',
  name: new TranslatableMarkup('Money (USD)'),
  viewers: ['table', 'datatables', 'gridjs', 'footable', 'spreadsheet'],
)]
class Money extends ViewerCellBase {

  /**
   * {@inheritdoc}
   */
  public function convert(mixed $value, array $row): mixed {
    return (is_float($value) || is_numeric($value)) ? '$' . number_format($value, 2) : $value;
  }

}
