<?php

namespace Drupal\viewer\Plugin\viewer\cell;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\viewer\Attribute\ViewerCell;
use Drupal\viewer\Plugin\ViewerCellBase;

/**
 * Percentage ViewerCell cell plugin.
 */
#[ViewerCell(
  id: 'percentage',
  name: new TranslatableMarkup('Percentage'),
  viewers: ['table', 'datatables', 'gridjs', 'footable', 'spreadsheet'],
)]
class Percentage extends ViewerCellBase {

  /**
   * {@inheritdoc}
   */
  public function convert(mixed $value, array $row): mixed {
    return !empty($value) ? $value . '%' : '0%';
  }

}
