<?php

namespace Drupal\viewer\Plugin\viewer\type;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\file\Entity\File;
use Drupal\viewer\Attribute\ViewerType;
use Drupal\viewer\Plugin\ViewerTypeBase;

/**
 * Viewer Type plugin.
 */
#[ViewerType(
  id: 'pdf',
  name: new TranslatableMarkup('PDF'),
  default_viewer: 'pdfjs',
  extensions: [
    'application/pdf' => 'pdf',
  ],
)]
class Pdf extends ViewerTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getContentAsArray(File $file, $settings = []): array {
    return [];
  }

}
