<?php

namespace Drupal\viewer\Plugin\viewer\viewer;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\viewer\Attribute\Viewer;

/**
 * Viewer plugin.
 */
#[Viewer(
  id: 'apexchart_bubble',
  name: new TranslatableMarkup('ApexCharts.js: Bubble'),
  processor: 'processor_csv',
  filters: TRUE,
  viewer_types: ['csv'],
)]
class ApexBubble extends ApexScatter {

  /**
   * {@inheritdoc}
   */
  public function getRenderable(): array {
    $build = parent::getRenderable();
    $build['#wrapper'] = 'scatterbubble';
    $build['#type'] = 'bubble';
    return $build;
  }

}
