<?php

namespace Drupal\viewer\Plugin\viewer\viewer;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\viewer\Attribute\Viewer;

/**
 * Viewer plugin.
 */
#[Viewer(
  id: 'apexchart_piedoughnut',
  name: new TranslatableMarkup('ApexCharts.js: Pie/Doughnut'),
  processor: 'processor_csv',
  filters: TRUE,
  viewer_types: ['csv'],
)]
class ApexPieDoughnut extends ChartPieDoughnut {

  /**
   * {@inheritdoc}
   */
  public function getRenderable(): array {
    $build = parent::getRenderable();
    $build['#type'] = $build['#type'] == 'pie' ? 'pie' : 'donut';
    $build['#theme'] = 'viewer_apexchart';
    $build['#wrapper'] = 'piedoughnut';
    $build['#attached'] = [
      'library' => ['viewer/viewer.apexcharts_piedoughnut'],
    ];
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state, array $params = []): array {
    $form = parent::settingsForm($form, $form_state, $params);
    unset($form['general']['aggregate']);
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsValues(array &$form, FormStateInterface $form_state): array {
    $settings = parent::settingsValues($form, $form_state);
    unset($settings['aggregate']);
    return $settings;
  }

}
