<?php

namespace Drupal\viewer\Plugin\viewer\viewer;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\viewer\Attribute\Viewer;

/**
 * Viewer plugin.
 */
#[Viewer(
  id: 'chartjs_bar',
  name: new TranslatableMarkup('Chart.js: Bar'),
  processor: 'processor_csv',
  filters: TRUE,
  viewer_types: ['csv'],
)]
class ChartBar extends ChartLine {

  /**
   * {@inheritdoc}
   */
  public function getRenderable(): array {
    $build = parent::getRenderable();
    $build['#type'] = 'bar';
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state, array $params = []): array {
    $settings = $params['settings'];
    $form = parent::settingsForm($form, $form_state, $params);
    $form['options']['horizontal'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Horizontal bars'),
      '#default_value' => !empty($settings['horizontal']) ? $settings['horizontal'] : FALSE,
      '#states' => [
        'visible' => [':input[name="type"]' => ['value' => 'bar']],
      ],
    ];
    unset($form['options']['chart_type'], $form['options']['chart_curve']);
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsValues(array &$form, FormStateInterface $form_state): array {
    $settings = parent::settingsValues($form, $form_state);
    $settings += [
      'horizontal' => $form_state->getValue('horizontal'),
    ];
    return $settings;
  }

}
