<?php

namespace Drupal\viewer\Plugin\viewer\viewer;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\viewer\Attribute\Viewer;

/**
 * Viewer plugin.
 */
#[Viewer(
  id: 'vertical_tabs',
  name: new TranslatableMarkup('Tabs (vertical)'),
  empty_viewer_source: TRUE,
)]
class VerticalTabs extends Tabs {

  /**
   * {@inheritdoc}
   */
  public function getRenderable(): array {
    $configuration = $this->getConfiguration();
    $tabs = !empty($configuration['items']) ? $configuration['items'] : [];
    $vertical_tabs = [];
    $key_indexes = [];
    foreach ($tabs as $details) {
      if ($viewer = $this->getViewerByUuid($details['viewer_id'])) {
        $plugin = $viewer->getViewerPlugin()->setViewer($viewer);
        $title = !empty($details['title']) ? $details['title'] : $viewer->label();
        $key = $this->getMachineName($title);
        if (!isset($key_indexes[$key])) {
          $key_indexes[$key] = 0;
        }
        else {
          $key_indexes[$key]++;
        }
        $vertical_tabs[$key . '_' . $key_indexes[$key]] = [
          'title' => $title,
          'element' => $plugin->getRenderable(),
          'is_default' => !empty($details['default']),
        ];
      }
    }
    return $this->formBuilder->getForm('\Drupal\viewer\Form\VerticalTabs', $vertical_tabs, $this->getSettings());
  }

}
