<?php

namespace Drupal\viewer\Services;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Queue\QueueFactory;

/**
 * Viewer Source cron imports.
 *
 * @ingroup viewer
 */
class Cron {

  /**
   * Initiates Cron service.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
    protected QueueFactory $queue,
    protected TimeInterface $time,
  ) {}

  /**
   * Create and process Viewer Source import queues.
   */
  public function processQueue(): void {
    $current_timestamp = $this->time->getCurrentTime();
    $import_queue = $this->queue->get('viewer_sources');
    $ids = $this->entityTypeManager->getStorage('viewer_source')
      ->getQuery()
      ->condition('status', 1)
      ->condition('import_frequency', 0, '!=')
      ->condition('next_import', $current_timestamp, '<=')
      ->accessCheck(TRUE)
      ->execute();
    $entities = $this->entityTypeManager->getStorage('viewer_source')->loadMultiple($ids);
    foreach ($entities as $viewer_source) {
      $plugin = $viewer_source->getSourcePlugin();
      $settings = $viewer_source->getSettings();
      $plugin->setImportFrequency($viewer_source->getFrequency())
        ->setBatchSettings($settings)
        ->setBatchViewerSourceEntity($viewer_source)
        ->setBatchFile($settings['path'])
        ->setBatchFileSource($viewer_source->getSourcePluginId());
      $import_queue->createItem($plugin);
    }
  }

}
