<?php

declare(strict_types=1);

namespace Drupal\views_adjustable_table;

use Drupal\Core\Security\TrustedCallbackInterface;
use Drupal\Component\Utility\Html;

class BsmSelect implements TrustedCallbackInterface {
  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks() {
    return ['preRender'];
  }

  /**
   * Pre-render function for columns select - initialises bmselect library.
   */
  public static function preRender($element) {
    if (empty($element['#attributes']['id'])) {
      return $element;
    }

    $select_title = Html::escape(t('Select columns')->render());
    $remove_title = 'x';

    $element['#attached']['library'][] = 'views_adjustable_table/views_adjustable_table.core';

    // Pass values from PHP to JS.
    $element['#attached']['drupalSettings']['views_adjustable_table']['id'] = Html::escape($element['#attributes']['id']);
    $element['#attached']['drupalSettings']['views_adjustable_table']['select_title'] = $select_title;
    $element['#attached']['drupalSettings']['views_adjustable_table']['remove_title'] = $remove_title;

    return $element;
  }
}
