<?php

namespace Drupal\views_adjustable_table\Plugin\views\filter;

use Drupal\views\Plugin\views\filter\FilterPluginBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\views_adjustable_table\BsmSelect;

/**
 * Filter plugin that provides a selectable columns filter.
 *
 * @ingroup views_filter_handlers
 *
 * @ViewsFilter("at_selection")
 */
class SelectionHandler extends FilterPluginBase {

  /**
   * {@inheritdoc}
   */
  public function canExpose() {
    return (get_class($this->view->style_plugin) === 'Drupal\views_adjustable_table\Plugin\views\style\AdjustableTable');
  }

  /**
   * {@inheritdoc}
   */
  public function isExposed() {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function buildExposedForm(&$form, FormStateInterface $form_state) {
    $style_plugin = $this->view->style_plugin;

    if (get_class($style_plugin) !== 'Drupal\views_adjustable_table\Plugin\views\style\AdjustableTable') {
      return [];
    }

    $options = $style_plugin->options;

    if (empty($options['info'])) {
      return [];
    }

    $fields = $this->view->field;
    $columns = $style_plugin->sanitizeColumns($options['columns'], $fields);
    $field_nos = [];
    $field_options = [];

    foreach (array_keys($fields) as $field_no => $field) {
      $field_nos[$field] = $field_no;
    }

    foreach ($columns as $field => $column) {
      if ($field == $column && empty($fields[$field]->options['exclude'])) {
        $id = 'f' . $field_nos[$field];
        $field_options[$id] = $fields[$field]->label();
      }
    }

    if (empty($field_options)) {
      return [];
    }

    $input = $this->view->getExposedInput();

    $selected_options = [];

    if (!empty($input['columns'])) {
      foreach ($input['columns'] as $key) {
        if (array_key_exists($key, $field_options)) {
          $selected_options[$key] = $field_options[$key];
          unset($field_options[$key]);
        }
      }
      $field_options = $selected_options + $field_options;
    }

    $form['columns'] = [
      '#type' => 'select',
      '#multiple' => TRUE,
      '#title' => t('Columns'),
      '#options' => $field_options,
    ];

    if ((isset($options['column_selection_widget'])) && ($options['column_selection_widget'] == 'bsmselect')) {
      $form['columns']['#attached']['library'][] = 'core/jquery.ui.draggable';
      $form['columns']['#attached']['library'][] = 'core/jquery.ui.droppable';
      $form['columns']['#attached']['library'][] = 'core/jquery.ui.sortable';
      $form['columns']['#attached']['library'][] = 'views_adjustable_table/views_adjustable_table.bsmselect.core';
      $form['columns']['#attached']['library'][] = 'views_adjustable_table/views_adjustable_table.bsmselect.sortable';
      $form['columns']['#pre_render'][] = [BsmSelect::class, 'preRender'];
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function exposedInfo() {
    return [];
  }

}
