<?php

declare(strict_types=1);

namespace Drupal\Tests\views_area_library\Kernel;

use Drupal\Tests\views\Kernel\ViewsKernelTestBase;
use Drupal\views\Views;
use Drupal\views_area_library\Plugin\views\area\Library;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests the library area handler.
 */
#[Group('views_area_library')]
class AreaLibraryTest extends ViewsKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'views_area_library',
  ];

  /**
   * {@inheritdoc}
   */
  public static $testViews = ['test_view'];

  /**
   * Tests the library area handler.
   */
  public function testAreaLibrary(): void {
    $library = 'system/base';
    $view = Views::getView('test_view');
    $view->setDisplay();
    $handler_name = $this->randomMachineName();
    $view->displayHandlers->get('default')->overrideOption('header', [
      $handler_name => [
        'id' => 'library',
        'table' => 'views',
        'field' => 'library',
        'plugin_id' => 'library',
        'library' => $library,
      ],
    ]);

    // Execute the view.
    $this->executeView($view);

    $library_handler = $view->display_handler->handlers['header'][$handler_name];
    $this->assertInstanceOf(Library::class, $library_handler);
    $expected_build = ['#attached' => ['library' => [$library]]];
    $actual_build = $library_handler->render();
    $this->assertEquals($expected_build, $actual_build);
  }

}
