<?php

declare(strict_types=1);

namespace Drupal\views_area_library\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook implementations for views_area_library.
 */
class ViewsAreaLibraryViewsHooks {
  use StringTranslationTrait;

  /**
   * Implements hook_views_data().
   */
  #[Hook('views_data')]
  public function viewsData(): array {
    $data['views']['library'] = [
      'title' => $this->t('Attach library'),
      'help' => $this->t('Attach a library to the view.'),
      'area' => ['id' => 'library'],
    ];
    return $data;
  }

}
