INTRODUCTION
------------

A views argument/contextual fulldate filter for datetime_range fields that checks if the given fulldate is between the start and end dates rather than just looking at the start date.

REQUIREMENTS
------------

* Views module.

INSTALLATION
------------

Enable the module.
You should get a (full date - between) contextual filter in views for daterange fields.

CONFIGURATION
-------------

* Add the contextual filter (full_date - between) to your view.

USE CASE
-------------

Say you have a node for an event with a daterange field on it for a start and end time.
You want to create a views page with a contextual filter for the day to show all events on that day.
The path might be '/day/20250511' for May 11 2025.
If you add the contextual filter "node.field_date_and_time (full_date)" for example, it will only show events that start on that date.
It will not show events that may start the day before but end on that day.

This module provides a contextual filter "node.field_date_and_time (full_date - between)" that looks at if the given argument is between the start and end dates.
