<?php

namespace Drupal\views_argument_default_node_title_from_url\Plugin\views\argument_default;

use Drupal\node\Plugin\views\argument_default\Node;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\views\Attribute\ViewsArgumentDefault;

/**
 * Default argument plugin to extract a node title from the URL.
 */
#[ViewsArgumentDefault(
  id: 'node_title_from_url',
  title: new TranslatableMarkup('Content Title from URL'),
)]
class NodeTitleFromUrl extends Node {

  /**
   * {@inheritdoc}
   */
  public function getArgument() {
    $node = $this->routeMatch->getParameter('node');
    if ($node instanceof \Drupal\node\NodeInterface) {
      return $node->getTitle();
    }
    return NULL;
  }
}
