# Views Base URL

This module provides a new Views field that can generate **absolute internal
URLs** based on custom parameters such as an internal path, query string values,
and fragments.

The generated URL automatically respects the current site language, ensuring
that multilingual sites produce links in the correct language.

You can also generate a complete HTML link from the URL, with customizable link
text and attributes (class, title, target, rel, etc.).

All settings support token replacement patterns, except for the target and rel
attributes.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/views_base_url).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/views_base_url).


## Requirements

This module requires no modules outside of Drupal core (Views).


## Installation

Install as you would normally install a contributed Drupal module.
For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Usage

### Custom internal URL

- Select field formatter in view, and add **Global: Custom Internal URL**
- Select **Exclude from display** option.
- Create custom link by adding a **Global: Custom text**
- Create a link using replacement pattern like this:

```html
<a href="{{ custom_internal_url }}">My home page</a>
```

You can also check the **Render as link** configuration option to generate a
complete HTML link.

### Base URL (Deprecated)

This Views field was historically using the `global $base_url` variable to
generate URLs.

- Select field formatter in view, and add **Global: Base URL**
- Select **Exclude from display** option.
- Create custom link by adding a **Global: Custom text**
- Create link using replacement pattern like this:

```html
<a href="{{ base_url }}/home">My home page</a>
```

### Similar modules

The [Views custom link](https://www.drupal.org/project/views_custom_link)
it pretty similar to this module but only allows generating urls and links
based on a route name and route parameters.  This module is more flexible
and allows to generate URLs based on any internal path, query parameters and
fragments.


## Maintainers

### Current maintainer

- [mably](https://drupal.org/u/mably)

### Historical maintainers

- [subhojit777](https://www.drupal.org/u/subhojit777)
- [rjjakes](https://www.drupal.org/u/rjjakes)
