# Views Conditional Text

Views Conditional Text provides a **Query-only mode** for Views displays.
This allows you to use Views purely for **querying and conditional logic**, without rendering any fields or rows.

The module is intended for scenarios where you want to **display custom text or markup based on whether a View returns results**, while still leveraging Views filters, relationships, and contextual filters.

---

## How to Use

### 1. Create or Edit a View

Create a View using any base entity (content, media, users, etc.).

Configure all required:

- Filters
- Relationships
- Contextual filters

These behave exactly as they do in standard Views.

---

### 2. Add a Page or Block Display

Add either:

- a **Page display**, or
- a **Block display**

Query-only mode is available **only for these display types**.

---

### 3. Enable Query-only Mode

In the display settings, enable:

**Query-only (conditional text) mode**

When enabled:

- Fields and rows are not rendered
- Exposed filters and pagers are suppressed
- The View query still executes fully

---

### 4. Use Header / Empty Areas for Output

Use standard Views areas to control output:

- **Header**
  Displayed when the View returns results

- **Empty text**
  Displayed when the View returns no results

- **Footer** (optional)
  Displayed in both cases

No fields are required for output.

---

## Expected Behavior

| View Result   | Displayed Output       |
| ------------- | ---------------------- |
| Results exist | Header content         |
| No results    | Empty text             |
| Any result    | Footer (if configured) |

---

## Typical Use Cases

- Show messages based on content availability
- Display conditional banners or alerts
- Use Views as a reusable query engine
- Avoid rendering placeholder fields
- Replace custom database queries with Views logic

---

## Notes

- Fields may exist in the View configuration but are ignored when query-only mode is enabled
- All Views access control and caching behavior is preserved
- No core files are altered

---

## License

GPL-2.0-or-later
