# Views Config Field

A Drupal module that provides a Views field plugin to display configuration values from Drupal's configuration system.

## Overview

The Views Config Field module allows site builders to add any Drupal configuration value as a field in Views. This is particularly useful for displaying site settings, module configuration, or any other configurable values directly in Views without requiring custom code.

## Features

- **Configuration Field Plugin**: Adds a new field type to Views that can display any configuration value
- **Nested Key Support**: Supports dot notation for accessing nested configuration values (e.g., `site.name` or `user.settings.anonymous`)
- **Flexible Configuration**: Works with any Drupal configuration object
- **Cache Integration**: Properly integrates with Drupal's caching system
- **Type Safety**: Built with PHP 8.1+ features and strict typing

## Requirements

- Drupal 10.3 or higher
- PHP 8.1 or higher

## Installation

1. Download and install the module using Composer:
   ```bash
   composer require drupal/views_config_field
   ```

2. Enable the module:
   ```bash
   drush en views_config_field
   ```

   Or install via the Drupal admin interface at `/admin/modules`.

## Usage

### Adding a Config Field to a View

1. Edit any View that supports fields
2. Add a new field
3. Select "Config value" from the field list
4. Configure the field:
   - **Configuration name**: The configuration object to load (e.g., `system.site`, `user.settings`)
   - **Configuration key**: The property to display (e.g., `name`, `email`, `anonymous`)

### Examples

#### Display Site Name
- **Configuration name**: `system.site`
- **Configuration key**: `name`

#### Display Site Email
- **Configuration name**: `system.site`
- **Configuration key**: `mail`

#### Display Anonymous User Name
- **Configuration name**: `user.settings`
- **Configuration key**: `anonymous`

#### Display Nested Configuration Values
For nested configuration values, use dot notation:
- **Configuration name**: `system.performance`
- **Configuration key**: `css.preprocess`

### Advanced Usage

The module supports complex nested configuration structures. For example, if you have a custom module configuration like:

```yaml
# my_module.settings.yml
api:
  endpoints:
    primary: "https://api.example.com"
    fallback: "https://backup.example.com"
  timeout: 30
```

You can access these values using:
- `api.endpoints.primary` for the primary endpoint URL
- `api.endpoints.fallback` for the fallback endpoint URL
- `api.timeout` for the timeout value

## Configuration

The module provides a single Views field plugin with the following configuration options:

- **Configuration name** (required): The name of the configuration object to load
- **Configuration key** (required): The key or nested key path to the value to display

## API

### Views Field Plugin

The module provides a single Views field plugin:

- **Plugin ID**: `views_config_field`
- **Class**: `Drupal\views_config_field\Plugin\views\field\ViewsConfigField`

### Hook Implementation

The module implements `hook_views_data_alter()` to register the field plugin with Views.

## Caching

The field plugin properly implements `CacheableDependencyInterface` and uses `CacheableDependencyTrait` to ensure that Views containing config fields are properly invalidated when the underlying configuration changes.

## Development

```
git clone git@git.drupal.org:project/views_config_field.git
cd views_config_field
ddev config --project-type=drupal --docroot=web --php-version=8.3 --corepack-enable --project-name=views-config-field
ddev add-on get ddev/ddev-drupal-contrib
ddev add-on get ddev/ddev-selenium-standalone-chrome
ddev start
ddev poser
ddev symlink-project
ddev drush site:install -y
ddev drush pm:install views_config_field -y
ddev drush user:login
```

## Support

- **Issues**: [Issue queue](https://www.drupal.org/project/issues/views_config_field)

