<?php

namespace Drupal\views_csv_source\Plugin\views\field;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Provides a constant value for all rows, useful for aggregation.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("csv_constant")
 */
class Constant extends FieldPluginBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['constant_value'] = ['default' => 'all_results'];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
    $form['constant_value'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Constant value'),
      '#description' => $this->t('The value to use for all rows.'),
      '#default_value' => $this->options['constant_value'],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    $this->ensureMyTable();
    $this->field_alias = $this->query->addField($this->tableAlias, $this->options['id']);

    if (!empty($this->options['group_type']) && $this->options['group_type'] === 'group') {
      $this->query->groupby[] = $this->field_alias;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(ResultRow $values, $field = NULL) {
    return $this->options['constant_value'];
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    return $this->sanitizeValue($this->getValue($values));
  }

}
