<?php

namespace Drupal\views_csv_source\Plugin\views\filter;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Plugin\views\filter\NumericFilter;
use Drupal\views_csv_source\Plugin\views\ColumnSelectorTrait;

/**
 * Filter handler for views_csv_source with options.
 *
 * @ingroup views_filter_handlers
 *
 * @ViewsFilter("views_csv_source_filter_numeric")
 */
class ViewsCsvFilterNumeric extends NumericFilter {

  use ColumnSelectorTrait;

  /**
   * {@inheritdoc}
   */
  protected function defineOptions(): array {
    $options = parent::defineOptions();
    $options['key'] = ['default' => ''];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function operators(): array {
    $operators = parent::operators();
    unset($operators['not_regular_expression']);
    return $operators;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state): void {
    parent::buildOptionsForm($form, $form_state);

    $form = $this->buildKeyOptionElement($form);
  }

  /**
   * {@inheritdoc}
   */
  public function query(): void {
    $this->ensureMyTable();
    $info = $this->operators();
    if (!empty($info[$this->operator]['method'])) {
      $this->{$info[$this->operator]['method']}($this->options['key']);
    }
  }

}
