CONTENTS OF THIS FILE
---------------------

 * Introduction
 * Why this module?
 * Requirements
 * Installation
 * Configuration
 * How to use
 * Maintainers


INTRODUCTION
------------

This module is an extension of the Views module designed to work with data
stored in a comma-separated values (CSV) file. The file can be uploaded or
hosted on a remote server. The module provides a way to read the data from the
CSV file and display it in any of the formats available through Views. The
module also provides a way to filter and sort the data using the Views module.

 * For a full description of the module, visit the project page:
   https://www.drupal.org/project/views_csv_source

 * To submit bug reports and feature suggestions, or to track changes:
   https://www.drupal.org/project/issues/search/views_csv_source

WHY THIS MODULE?
----------------

There are several reasons you may want to use this module:

 * You want the power of Views to view data, but you don't want to create a
   new content type or entity to store the data. This could be because the data
   do not fit with your site's content model, or because you don't want to
   create a new content type for a one-off use case.
 * You want to connect to a data source that's not already within your site
   and is not in a database or easily accessible through an API.
 * The amount of data you want to display at once is too large for Views to
   handle (in our experience, Views can rarely handle more than a few hundred
   rows of data at once).


REQUIREMENTS
------------

No special requirements.


INSTALLATION
------------

 * Install as you would normally install a contributed Drupal module.
   See: https://www.drupal.org/node/895232 for further information.


CONFIGURATION
-------------

No configuration is needed.


HOW TO USE
----------

When creating a View, choose "CSV" in the "Show" field.

On the "Edit View" page, in the "Advanced" section, find the "Query settings"
section and click the "Settings" link. Inside the modal, you must
enter a link to the CSV file. It can either be a link to a file within your
filesystem or a link to a file sitting on a different server. Links that
do not have a .csv extension will work as long as the file generated by the
link is a CSV file. If you need authentication to access the file, you can
pass headers like this:

```
{"Authorization":"Basic xxxxx","Content-Type":"application/csv"}
```
where `xxxxx` is the base64 encoded username and password.

After applying the settings, you can proceed to select the columns you want to
display in the view, with each column being represented by a field in the view.
All of your columns will use the same field plugin, which has the title:
"CSV Field". Inside the settings for the field, you can choose the column you
want to display using the "Column Selector" dropdown.

Like with other Views fields, you can rewrite the output of the field, add
custom classes, and even use the values with other field plugins, such as the
one provided by the contributed module Views Simple Math Field.

There are two types of filters available: "CSV Field" and
"CSV Field Options". The "CSV Field" filter is a typical text filter.
The "CSV Field Options" filter provides a dropdown that is populated with
the unique values from the selected column (sorted). If your column has
more than one option in a cell, you can select a separator in the filter
settings and click "Refresh value options" to update the dropdown values.
Both of these filters can be exposed.

The module also comes with a sort and a contextual filter plugin.


MAINTAINERS
-----------
[//]: # cspell:disable
Current maintainers:
 * Daniel Cothran (andileco) - https://www.drupal.org/u/andileco
 * Nia Kathoni (nikathone) - https://www.drupal.org/u/nikathone
