<?php

/**
 * @file
 * Hook implementations for the Views Cumulative Field module.
 */

/**
 * Implements hook_views_data().
 */
function views_cumulative_field_views_data() {
  $data['views_cumulative_field']['table']['group'] = t('Global');
  $data['views_cumulative_field']['table']['join'] = [
    // Exist in all views.
    '#global' => [],
  ];
  $data['views_cumulative_field']['field_cumulative_field'] = [
    'title' => t('Cumulative Field'),
    'help' => t('Views field that calculates the cumulative value of another field in your view.'),
    'field' => [
      'id' => 'field_cumulative_field',
      // Allows users to specify how precise the results should be.
      // This is useful for divisions.
      'float' => TRUE,
    ],
  ];
  $data['views_cumulative_field']['field_cumulative_total'] = [
    'title' => t('Cumulative Total Field'),
    'help' => t('Views field that calculates and repeats per-row the cumulative value of another field in your view.'),
    'field' => [
      'id' => 'field_cumulative_total',
      // Allows users to specify how precise the results should be.
      // This is useful for divisions.
      'float' => TRUE,
    ],
  ];

  return $data;
}
