<?php

namespace Drupal\views_data_export_excel\Plugin\views\display;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views_data_export\Plugin\views\display\DataExport;
use Drupal\xls_serialization\Plugin\views\display\ExcelExportDisplayTrait;

/**
 * Provides an Excel export display plugin.
 *
 * This overrides the Data Export display to make labeling clearer on the admin
 * UI, and add specific Excel-related functionality.
 *
 * @ingroup views_display_plugins
 *
 * @ViewsDisplay(
 *   id = "data_export_excel",
 *   title = @Translation("Data Export Excel"),
 *   help = @Translation("Export the view results to an Excel file."),
 *   uses_route = TRUE,
 *   admin = @Translation("Data Export Excel"),
 *   returns_response = TRUE
 * )
 */
class ExcelExport extends DataExport {

  use ExcelExportDisplayTrait;

  /**
   * Overrides the content type of the data response.
   *
   * @var string
   */
  protected $contentType = 'xlsx';

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);

    switch ($form_state->get('section')) {
      case 'style':
        $this->buildStyleSectionForm($form, $form_state);
        break;

      case 'path':
        // Use default Views Data Export form.
        break;

      case 'format_header':
        $this->buildFormatHeaderSectionForm($form, $form_state);
        break;
    }

    $this->buildConditionalFormattingRulesForm($form, $form_state);
  }

}
