<?php

/**
 * @file
 * Documentation for views_entity_link API.
 */

use Drupal\Component\Utility\Html;
use Drupal\views\ViewExecutable;

/**
 * Alter views entity links.
 *
 * This may be utilized by modules or themes.
 *
 * @param array &$build
 *   Render array for the link.
 * @param \Drupal\views\ViewExecutable $view
 *   The view.
 * @param \Drupal\views_entity_link\Plugin\views\field\EntityLink $field
 *   The views field.
 */
function hook_views_entity_link_alter(array &$build, ViewExecutable $view, \Drupal\views_entity_link\Plugin\views\field\EntityLink $field) {
  // Restrict to this my view.
  if ($view->id() != 'my_view') {
    return;
  }

  // Add a class for my link.
  if ($field->options['link_template'] == 'my-entity-link') {
    $build['#options']['attributes']['class'][] = Html::getClass('my-link');
  }
}
