# Views Exclude Previous

This module provides a mechanism to exclude previously rendered entities during a page request, preventing duplication when multiple views or content listings appear on the same page.

## What it does

The module tracks entities that have been rendered during a page request using the `views_exclude_previous.render_history` service. It provides a Views argument default plugin that can be used to automatically exclude these entities from subsequent queries.

## Usage

### In Views

1. Add a contextual filter (argument) to your view for the entity ID field
2. Configure "When the filter value is NOT available":
   - Select "Provide default value"
   - Choose "Previously rendered entities"
   - Select the entity type to track

The view will now exclude any entities that have already been rendered on the page.

### Programmatic usage

The module provides a service and trait for tracking rendered entities:

```php
// Track a rendered entity
$render_history = \Drupal::service('views_exclude_previous.render_history');
$render_history->add($entity);

// Get previously rendered entities
$rendered_ids = $render_history->getRenderedEntities('node');
```

## Upgrade from 2.x or earlier

The 3.x version is a complete rewrite with a different architecture. There is **no upgrade path** from the 2.x version. Sites upgrading from 2.x must manually reconfigure their views to use the new "Previously rendered entities" argument default plugin.

## Credits

* 3.x development by drunomics GmbH
