# Views Exclude Previous

This module provides a mechanism to exclude previously rendered entities during a page request, preventing duplication when multiple views or content listings appear on the same page.

## What it does

The module tracks entities that have been rendered during a page request using the `views_exclude_previous.render_history` service. It provides a Views argument default plugin that can be used to automatically exclude these entities from subsequent queries.

## Usage

### In Views

#### Basic Setup

1. **Add a contextual filter** (argument) to your view for the entity ID field (e.g., "Content: ID" for nodes)

2. **Configure "When the filter value is NOT available"**:
   - Select "Provide default value"
   - Choose "Previously rendered entities"
   - Choose "Do not use a relationship" (this checks against the current page's entity)
   - Select the entity type to track (typically "Content" for nodes)

3. **Enable exclusion** (this is the crucial step many users miss):
   - Scroll all the way down to the bottom of the contextual filter settings
   - Expand the "More" section
   - Check the **"Exclude"** checkbox

The view will now exclude any entities that have already been rendered on the page.

#### Understanding Entity Type Selection

When you select "Content" as the entity type:
- The filter will track the current page's node/entity
- It will exclude that entity from your view results
- This prevents duplication when showing related content on the same page

### Programmatic usage

The module provides a service and trait for tracking rendered entities:

```php
// Track a rendered entity
$render_history = \Drupal::service('views_exclude_previous.render_history');
$render_history->add($entity);

// Get previously rendered entities
$rendered_ids = $render_history->getRenderedEntities('node');
```

## Upgrade from 2.x or earlier

The 3.x version is a complete rewrite with a different architecture. There is **no upgrade path** from the 2.x version. Sites upgrading from 2.x must manually reconfigure their views to use the new "Previously rendered entities" argument default plugin.

## Credits

* 3.x development by drunomics GmbH
