<?php

namespace Drupal\views_field_view_exposed_filter\Plugin\views\display;

use Drupal\views\Plugin\views\display\DisplayPluginBase;

/**
 * The plugin that adds an 'Exposed Source' display type.
 *
 * @ViewsDisplay(
 * id = "exposed_source",
 * title = @Translation("Exposed Source"),
 * help = @Translation("Provides a source of values for other views to filter against."),
 * uses_route = FALSE,
 * admin = "Exposed Source",
 * returns_response = FALSE
 * )
 */
class ExposedSourceDisplay extends DisplayPluginBase {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    // Force custom style plugin
    $options['style']['contains']['type'] = ['default' => 'views_field_view_exposed_source_style'];
    $options['defaults']['style'] = ['default' => FALSE];
    $options['defaults']['row'] = ['default' => FALSE];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function getType() {
    return 'exposed_source';
  }

  /**
   * API Method: Retrieves the raw array of values (For the Filter).
   */
  public function getExposedValues() {
    if (!$this->view->executed) {
      $this->view->execute();
    }
    return $this->view->style_plugin->getSourceValues();
  }

  /**
   * Preview method called by Views UI.
   */
  public function preview() {
    return $this->execute();
  }

  /**
   * Returns rendered table for Views Preview window.
   */
  public function execute() {
    if (!$this->view->executed) {
      $this->view->execute();
    }
    return $this->view->style_plugin->render();
  }
}
