<?php

/**
 * @file
 * Implements hook_views_data_alter().
 */

function views_field_view_exposed_filter_views_data_alter(array &$data) {
  foreach ($data as $table_name => $table_data) {
    foreach ($table_data as $field_name => $field_data) {
      // Look for fields that have a standard filter defined
      if (isset($field_data['filter']['id'])) {

        // Skip our own filters to avoid loops
        if (strpos($field_data['filter']['id'], 'exposed_source') !== FALSE) {
          continue;
        }

        // Create the new filter definition
        $filter_name = $field_name . '_exposed_source_filter';

        $data[$table_name][$filter_name] = $field_data;

        $title = $field_data['title'] ?? $field_data['title short'] ?? $field_name;
        $data[$table_name][$filter_name]['title'] = $title . ' (Exposed Source Filter)';

        $data[$table_name][$filter_name]['filter']['id'] = 'exposed_source_filter';

        $real_field = $field_data['real field'] ?? $field_name;
        $data[$table_name][$filter_name]['real field'] = $real_field;

        $data[$table_name][$filter_name]['help'] = t('Filters this field using a list populated by an Exposed Source View.');
      }
    }
  }
}
