# Views Flexbox

Views Flexbox provides a [Flexbox layout](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout/Flexbox)
for [Views](https://www.drupal.org/docs/8/core/modules/views) content. Results
are rendered in a simple flexbox layout which can be styled or themed as needed
within your project.

## Why Flexbox?

Flexbox provides a dynamic layout, which can be easily made mobile friendly,
allowing content to rearrange based on device width. This module attempts to
provide flexibility and usable defaults to provide a flexible implementation of
the Views Grid layout style, by leveraging flexbox in place of its row/columns
design.

## Styling

From within the views ui, you can enable a "Card" theme for the views layout.
This allows the content to display usability without work by the site
developers. Additional flexibility can be added via your theme's custom css.

## Similar Projects

If this project isn't helpful, you may find what you're looking for in one of
the following projects, which provide similar functionality.

    - [Views Fluid Grid](https://www.drupal.org/project/views_fluid_grid)
    - [Responsive Views Grid](https://www.drupal.org/project/responsive_views_grid)
    - [Views Flexbox Grid (on Github)](https://github.com/13jupiters/ViewsFlexbox)

## Installing

To install this project, download the latest release from Drupal.org, or add
it via composer using the following command.

```
composer require drupal/views_flexbox
```

Once downloaded into a Drupal project, enable the module through the Drupal
extention page or using a Drupal cli tool.

## Support

This module is an early implementation. Once its been tested, and reviewed a
full version will be released.

### Need help?

If you are running into issues with this module, or would like to suggest a
feature, please [open an issue](https://www.drupal.org/node/add/project-issue/views_flexbox)
in the project's queue.

### Want to help?

I'm happy to have other maintainers work on this project. If you're interested
in helping support this project, please reach out via
[the issue queue](https://www.drupal.org/project/issues/views_flexbox).
