CONTENTS OF THIS FILE
---------------------

 * Introduction
 * Requirements
 * Installation
 * Configuration
 * Maintainers


INTRODUCTION
------------
This module allows users to add blocks into the selected view between it's content
rows in specified places and on specified pages on the view edit form UI.
You can configure the view and display on which the blocks should appear and also
configure the block itself, specify position and pages on which it should appear.

You can also just create a configuration file with configured blocks data
if you don't want to configure them manually and the module will take care of the rest.

<b>IMPORTANT!</b>
Due to technical reasons this module does not support table style format.
The blocks will simply not appear when this style format is selected.

REQUIREMENTS
------------

This module requires no modules outside of Drupal core.

INSTALLATION
------------

Install the views_insert_blocks module as you would normally install a contributed
Drupal module.


CONFIGURATION
-------------

Simply go to your view edit form page, select the display on which you want to add blocks
and you will see a new form field in the third row `Add, configure and insert blocks into the view`.
This option is located under the Advanced section.

Simply click the button `Add block` and configure your block. THe configuration will then be saved
and the added block will show up on in your view in the configured place.

After adding the block, the edit button will appear under the `Add, configure and insert blocks into the view` form element which will let you edit or remove the added block.

You can also just create the configuration file programatically with the configured blocks,
the configuration file is named `views_insert_blocks.settings`, this is an example of the contents
of this file and the minimal configuration in order for this module to work:

```
-
  block_select: announce_block
  view_id: test_view
  display_id: page_1
  provider: announcements_feed
  label: 'Announcements Feed'
  block_position: end
  after: ''
  block_page: nth
  page_after: '2'
  page_nth: '1'
-
  view_id: test_view
  display_id: page_2
  block_select: 'system_menu_block:devel'
  provider: system
  label: dev
  block_position: start
  after: ''
  block_page: start
  page_after: ''
  page_nth: ''

```
The data of this configuration file is structured like this in the config object:

```
array:2 [▼
  0 => array:10 [▼
    "block_select" => "announce_block"
    "view_id" => "test_view"
    "display_id" => "page_1"
    "provider" => "announcements_feed"
    "label" => "Announcements Feed"
    "block_position" => "end"
    "after" => ""
    "block_page" => "nth"
    "page_after" => "2"
    "page_nth" => "1"
  ]
  1 => array:13 [▼
    "view_id" => "test_view"
    "display_id" => "page_2"
    "block_select" => "system_menu_block:devel"
    "provider" => "system"
    "label" => "dev"
    "block_position" => "start"
    "after" => ""
    "block_page" => "start"
    "page_after" => ""
    "page_nth" => ""
  ]
]
```

MAINTAINERS
-----------

 * Krzysztof Radaczyński - https://www.drupal.org/u/Vertorro

Supporting organization:

 * Smartbees - https://www.drupal.org/smartbees
