<?php

namespace Drupal\views_lazy_renderer\Hook;


use Drupal\Core\Config\Entity\ThirdPartySettingsInterface;
use Drupal\Core\Form\FormStateInterface;

class FormAlter {

  protected function addFormFields(&$form, FormStateInterface $form_state, $entity_type_id) {
    $bundle = $form_state->getFormObject()->getEntity();
    $bundle_id = $bundle->id();

    // Place in the "advanced" vertical tab group.
    $form['views_lazy_renderer'] = [
      '#type' => 'details',
      '#title' => t('Lazy renderer'),
      '#group' => 'additional_settings',
    ];

    $form['views_lazy_renderer']['allow_lazy_rendering'] = [
      '#type' => 'checkbox',
      '#title' => t('Allow this bundle to be rendered via the partial render controller'),
      '#default_value' => $bundle->getThirdPartySetting('views_lazy_renderer', 'allow_lazy_rendering', FALSE),
      '#description' => t('If checked, this bundle can be used in HTMX partial render requests.'),
    ];

    $view_modes = [];
    $entity_displays = \Drupal::entityTypeManager()
      ->getStorage('entity_view_display')
      ->loadByProperties([
        'targetEntityType' => $entity_type_id,
        'bundle' => $bundle_id,
      ]);

    foreach ($entity_displays as $display) {
      $vm = $display->getMode();
      $view_modes[$vm] = $vm;
    }
    $form['views_lazy_renderer']['allow_lazy_rendering_view_modes'] = [
      '#type' => 'checkboxes',
      '#title' => t('Allowed view modes for partial render'),
      '#options' => $view_modes,
      '#default_value' => $bundle->getThirdPartySetting('views_lazy_renderer', 'allow_lazy_rendering_view_modes', []),
      '#description' => t('Select which view modes of this bundle can be used in HTMX partial render requests.'),
    ];

    $form['#entity_builders'][] = [$this, 'formBuilder'];
  }

public function formBuilder($entity_type, ThirdPartySettingsInterface $type, &$form, FormStateInterface $form_state): void {
    $type->setThirdPartySetting('views_lazy_renderer', 'allow_lazy_rendering', $form_state->getValue('allow_lazy_rendering'));
    $type->setThirdPartySetting('views_lazy_renderer', 'allow_lazy_rendering_view_modes', $form_state->getValue('allow_lazy_rendering_view_modes'));
  }

}
