<?php

namespace Drupal\views_lazy_renderer\Hook;

use Drupal\Core\Hook\Attribute\Hook;

class ThemeSuggestions {

  #[Hook('theme_suggestions_views_lazy_row_alter')]
  public function addSuggestions(array &$suggestions, array $variables): void {
    $bundle = $variables['bundle'] ?? '';
    $view_mode = $variables['parameters']['view_mode'] ?? '';

    if (!empty($bundle) && !empty($view_mode)) {
      $suggestions[] = 'views_lazy_row__' . $bundle . '__' . $view_mode;
    }
  }

}
