<?php

namespace Drupal\views_lazy_renderer\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Url;
use Drupal\Core\Extension\ModuleHandlerInterface;

class Preprocess {

  public function __construct(
    private ModuleHandlerInterface $moduleHandler,
  ) {}

  #[Hook('preprocess_views_lazy_row')]
  public function buildLazyUrl(array &$variables): void {
    $entity_type_id = $variables['entity_type_id'] ?? '';
    $parameters = $variables['parameters'] ?? [];
    if ($entity_type_id === '' || $parameters === []) {
      return;
    }

    $route_name = "views_lazy_renderer.render.partial.$entity_type_id";
    $options = $variables['options'] ?? [];
    $url = Url::fromRoute($route_name, $parameters, $options)->toString();

    $context = [
      'route_name' => $route_name,
      'entity_type_id' => $entity_type_id,
      'parameters' => $parameters,
      'options' => $options,
      'variables' => $variables,
    ];
    $this->moduleHandler->alter('views_lazy_renderer_lazy_url', $url, $context);

    $variables['lazy_render_url'] = $url;
  }

}
