<?php

/**
 * @file
 * Hooks provided by the Views Lazy Renderer module.
 */

/**
 * Alter the lazy render URL used by the Views Lazy Renderer templates.
 *
 * @param string $url
 *   The URL string that will be used for the HX request.
 * @param array $context
 *   Contextual information about the URL being generated:
 *   - route_name: The default route name.
 *   - entity_type_id: The entity type being rendered.
 *   - parameters: Route parameters used to build the URL.
 *   - options: Route options passed to the URL generator.
 *   - variables: The theme variables for the lazy row template.
 */
function hook_views_lazy_renderer_lazy_url_alter(string &$url, array $context): void {
  // Example: Force absolute URLs.
  $url = \Drupal\Core\Url::fromRoute($context['route_name'], $context['parameters'], ['absolute' => TRUE])->toString();
}
