Views Mobile
============

This module provides an easy way to switch a Views display when the site is
accessed from a mobile or tablet device. It looks for alternate displays named
<display_id>_mobile and <display_id>_tablet and will switch to them when the
request comes from a mobile or tablet device.

Requirements
------------
- Drupal core (8/9/10/11 compatible)
- PHP 8.1+
- drupal/mobile_detect module (provides the mobile detection service)

Files of interest
-----------------
- views_mobile.module — lightweight procedural file (kept for compatibility)
- src/Hook/ViewsMobileHooks.php — attribute-based hook implementations
- src/Service/DisplaySwitcher.php — service that contains the switching logic
- views_mobile.services.yml — service registration
- tests/ — unit and kernel tests

Running tests using Lando
-------------------------
If you run your site with Lando (recommended), use the following commands
from the project root (where your .lando.yml is located). Adjust the service
name if your environment uses a different appserver name (e.g., 'appserver').

Run unit tests for this module:

```bash
lando php vendor/bin/phpunit web/modules/contrib/views_mobile/tests/src/Unit/DisplaySwitcherTest.php
```

Run kernel tests (uses Drupal testing framework):

```bash
lando php vendor/bin/phpunit --testsuite=kernel web/modules/contrib/views_mobile/tests/src/Kernel/ViewsMobileKernelTest.php
```

Note: Running kernel tests requires a test database and may need additional
configuration depending on your Lando setup. If tests fail due to environment
constraints, consider running them on your CI pipeline configured for Drupal.

Packaging for Drupal.org
------------------------
- Ensure your module directory contains an accurate .info.yml (core_version_requirement is set).
- Tag releases in git and create packaged releases on drupal.org.
- Keep composer.json up-to-date with "php" and module dependencies.

Development notes
-----------------
- The module now uses a service (`views_mobile.display_switcher`) to hold the
  switching logic. This makes it easier to test and maintain.
- The attribute-based hooks class `ViewsMobileHooks` is autowired as a
  service by Drupal and receives its dependencies via constructor injection.

If you want, I can:
- Run the unit and kernel tests via Lando now (I will attempt to run them using your Lando environment).
- Add CI configuration (GitHub Actions) to run tests on push.

