<?php

declare(strict_types=1);

namespace Drupal\tests\views_mobile\Unit;

use Drupal\views_mobile\Service\DisplaySwitcher;
use Detection\MobileDetect;
use PHPUnit\Framework\TestCase;
use Psr\Log\NullLogger;
use Drupal\views\ViewExecutable;

class DisplaySwitcherTest extends TestCase {

  public function testSwitchDisplayNoDetectorDoesNothing(): void {
    $logger = new NullLogger();
    $switcher = new DisplaySwitcher(NULL, $logger);

    // Create a lightweight mock of ViewExecutable.
    $view = $this->createMock(ViewExecutable::class);

    // Ensure no exception thrown.
    $switcher->switchDisplay($view, 'default', []);

    $this->assertTrue(true);
  }

  public function testSwitchDisplayWithDetectorSwitches(): void {
    $detect = $this->createMock(MobileDetect::class);
    $detect->method('isTablet')->willReturn(false);
    $detect->method('isMobile')->willReturn(true);

    // Create a stub view that responds to displayHandlers->has and setDisplay.
    $view = $this->getMockBuilder(ViewExecutable::class)->disableOriginalConstructor()->getMock();

    // Create a simple displayHandlers object with has() and no other behavior.
    $displayHandlers = new class {
      protected $ids = ['default_mobile' => 'default_mobile'];
      public function has($id) { return isset($this->ids[$id]); }
    };

    // Inject displayHandlers property.
    $ref = new \ReflectionProperty($view, 'displayHandlers');
    $ref->setAccessible(true);
    $ref->setValue($view, $displayHandlers);

    // Expect setDisplay to be called with default_mobile.
    $view->expects($this->once())->method('setDisplay')->with('default_mobile');

    $logger = new NullLogger();
    $switcher = new DisplaySwitcher($detect, $logger);

    $switcher->switchDisplay($view, 'default', []);
  }

}

