<?php

declare(strict_types=1);

namespace Drupal\views_query\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;

/**
 * The views_query_extend attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class ViewsQueryExtend extends AttributeBase {

  /**
   * Constructs a new ViewsQueryExtend instance.
   *
   * @param string $id
   *   The plugin ID. There are some implementation bugs that make the plugin
   *   available only if the ID follows a specific pattern. It must be either
   *   identical to group or prefixed with the group. E.g. if the group is "foo"
   *   the ID must be either "foo" or "foo:bar".
   * @param int|null $weight
   *   An optional weight for the query extension plugin.
   * @param string|null $title
   *   Optional human-readable title used for the auto-generated checkbox.
   * @param string|null $description
   *   Optional description used for the auto-generated checkbox.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?int $weight = NULL,
    public readonly ?string $title = NULL,
    public readonly ?string $description = NULL,
  ) {}

}
