<?php

declare(strict_types=1);

namespace Drupal\views_query;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Database\Query\SelectInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\views_query\Plugin\views\query\ViewsQuerySql;

/**
 * Interface for ViewsQuery plugins.
 */
interface ViewsQueryInterface extends PluginInspectionInterface {

  /**
   * Information about options for all kinds of purposes will be held here.
   * @code
   * 'option_name' => [
   *  - 'default' => default value,
   *  - 'contains' => (optional) array of items this contains, with its own
   *      defaults, etc. If contains is set, the default will be ignored and
   *      assumed to be [].
   *  ],
   * @endcode
   *
   * @return array
   *   Returns the options of this handler/plugin.
   */
  public function defineOptions(): array;

  /**
   * Add settings for the ui.
   *
   * @param array $form
   *   An alterable, associative array containing the structure of the form,
   *   passed by reference.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param \Drupal\views_query\Plugin\views\query\ViewsQuerySql $views_query
   *   The ViewsQuerySql instance.
   */
  public function buildOptionsForm(array &$form, FormStateInterface $form_state, ViewsQuerySql $views_query): void;

  /**
   * Special submit handling.
   *
   * @param array $form
   *   An alterable, associative array containing the structure of the form,
   *   passed by reference.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param \Drupal\views_query\Plugin\views\query\ViewsQuerySql $views_query
   *   The ViewsQuerySql instance.
   */
  public function submitOptionsForm(&$form, FormStateInterface $form_state, ViewsQuerySql $views_query): void;

  /**
   * Alter/extend the views queries.
   *
   * @param \Drupal\Core\Database\Query\SelectInterface $query
   *   The sql query returned by \Drupal\views\Plugin\views\query\Sql->query().
   * @param bool $get_count
   *   Provide a countQuery if this is true, otherwise provide a normal query.
   * @param \Drupal\views_query\Plugin\views\query\ViewsQuerySql $views_query
   *   The ViewsQuerySql instance.
   */
  public function queryAlter(SelectInterface $query, bool $get_count, ViewsQuerySql $views_query): void;

  /**
   * Allows altering the results after the entities have been assigned.
   *
   * @param mixed[][] $ids
   *   A two dimensional array of identifiers (entity ID / revision ID) keyed by
   *   relationship.
   * @param \Drupal\Core\Entity\EntityInterface[] $entities
   *   An array of entities keyed by their identified (entity ID / revision ID).
   * @param \Drupal\views\ResultRow[] $results
   *   The entire views result.
   */
  public function assignEntitiesToResultAlter($ids, array $entities, array &$results): void;

}
