<?php

declare(strict_types=1);

namespace Drupal\views_query;

use Drupal\Component\Utility\SortArray;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\views_query\Attribute\ViewsQueryExtend;

/**
 * ViewsQuery plugin manager.
 */
class ViewsQueryPluginManager extends DefaultPluginManager {

  /**
   * Constructs the ViewsQueryPluginManager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/views/query_extend', $namespaces, $module_handler, ViewsQueryInterface::class, ViewsQueryExtend::class);
    $this->alterInfo('views_plugins_query_extend');
    $this->setCacheBackend($cache_backend, 'views:query_extend');
  }

  /**
   * {@inheritdoc}
   */
  protected function findDefinitions() {
    $definitions = parent::findDefinitions();

    // Sort the setting plugins by weight.
    uasort($definitions, [SortArray::class, 'sortByWeightElement']);
    return $definitions;
  }

}
