<?php

declare(strict_types=1);

namespace Drupal\views_query_test\Plugin\views\query_extend;

use Drupal\Core\Database\Query\SelectInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\views_query\Attribute\ViewsQueryExtend;
use Drupal\views_query\Plugin\views\query\ViewsQuerySql;
use Drupal\views_query\ViewsQueryPluginBase;

/**
 * Test plugin for views_query_test.
 */
#[ViewsQueryExtend(
  id: 'test_foo',
  weight: 0,
  title: 'Test Foo option',
  description: 'Enables Foo behavior for testing.',
)]
final class TestFooSql extends ViewsQueryPluginBase {

  /**
   * {@inheritdoc}
   */
  public function submitOptionsForm(&$form, FormStateInterface $form_state, ViewsQuerySql $views_query): void {}

  /**
   * {@inheritdoc}
   */
  protected function doQueryAlter(SelectInterface $query, bool $get_count, ViewsQuerySql $views_query): void {
    // Add a recognizable tag to the SQL query for assertions.
    $query->addTag('views_query_test_foo');
  }

}
