<?php

declare(strict_types=1);

namespace Drupal\views_query_test_alt\Plugin\views\query_extend;

use Drupal\Core\Database\Query\SelectInterface;
use Drupal\views_query\Attribute\ViewsQueryExtend;
use Drupal\views_query\Plugin\views\query\ViewsQuerySql;
use Drupal\views_query\ViewsQueryPluginBase;

/**
 * Test plugin for views_query_test_alt.
 */
#[ViewsQueryExtend(
  id: 'test_baz',
  weight: 0,
  title: 'Test Baz option',
  description: 'Enables Baz behavior for testing.',
)]
final class TestBazSql extends ViewsQueryPluginBase {

  /**
   * {@inheritdoc}
   */
  protected function doQueryAlter(SelectInterface $query, bool $get_count, ViewsQuerySql $views_query): void {
    $query->addTag('views_query_test_baz');
  }

}
