<?php

declare(strict_types=1);

namespace Drupal\tests\views_query\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\views_query\Plugin\views\query\ViewsQuerySql;

/**
 * Tests the execution of ViewsQuery plugins.
 *
 * @group views_query
 */
final class ViewsQueryAlterExecutionTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'views',
    'views_query',
    'views_query_test',
  ];

  /**
   * Tests that the plugin is not executed when disabled.
   */
  public function testPluginDoesNotAlterWhenDisabled(): void {
    $connection = $this->container->get('database');
    $select = $connection->select('users_field_data', 'u');

    /** @var \Drupal\views_query\ViewsQueryPluginManager $manager */
    $manager = $this->container->get('plugin.manager.views_query');

    // Build a minimal handler with options disabled.
    $handler = ViewsQuerySql::create($this->container, [], 'views_query', []);
    // Set options via reflection.
    $ref = new \ReflectionClass($handler);
    $prop = $ref->getParentClass()->getProperty('options');
    $prop->setAccessible(TRUE);
    $prop->setValue($handler, [
      'test_foo' => 0,
    ]);

    // Call the test plugin directly with the handler context.
    /** @var \Drupal\views_query_test\Plugin\views\query_extend\TestFooSql $plugin */
    $plugin = $manager->createInstance('test_foo');
    $plugin->queryAlter($select, FALSE, $handler);

    $this->assertFalse($select->hasTag('views_query_test_foo'));
  }

  /**
   * Tests that the plugin is executed when enabled.
   */
  public function testPluginAltersQueryWhenEnabled(): void {
    $connection = $this->container->get('database');
    $select = $connection->select('users_field_data', 'u');

    /** @var \Drupal\views_query\ViewsQueryPluginManager $manager */
    $manager = $this->container->get('plugin.manager.views_query');

    // Build a minimal handler with the option enabled.
    $handler = ViewsQuerySql::create($this->container, [], 'views_query', []);
    // Set options via reflection.
    $ref = new \ReflectionClass($handler);
    $prop = $ref->getParentClass()->getProperty('options');
    $prop->setAccessible(TRUE);
    $prop->setValue($handler, [
      'test_foo' => 1,
    ]);

    /** @var \Drupal\views_query_test\Plugin\views\query_extend\TestFooSql $plugin */
    $plugin = $manager->createInstance('test_foo');
    $plugin->queryAlter($select, FALSE, $handler);

    $this->assertTrue($select->hasTag('views_query_test_foo'));
  }

}
