# View Scored Sort

The Views Scored Sort module is intended to allow site builders to apply
scoring rules to their views.

It was originally designed to fulfill a requirement similar to the following:
Design a view that will show related content for a node. It will primarily show
nodes that share a taxonomy term with the current node, giving a higher score
for each taxonomy term that is shared. In addition, content will be penalized if
it is too old. The result should be something like 70% taxonomy term sharing,
30% date.

For now, the module only supports scoring date and taxonomy term fields. The
plan is to eventually set rules for strings, other entity reference fields, and
more field types.

For a full description of the module, visit the
[project page](https://drupal.org/project/views_scored_sort).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://drupal.org/project/issues/views_scored_sort).


## Table of contents

- Requirements
- Installation
- Configuration


## Requirements

- Core modules
  - views

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

Configure scores for your sorts on the [configuration page](/admin/config/views_scored_sort/sorting-rules).

Configuration options include:
* Whether to require at least one match on a specified taxonomy term field for
the row to appear in the view.
* How many points to assign to a views row that has a taxonomy term match, with
more points assigned per match.
* Whether to penalize content based on its age vs. the current date, or its age
vs. the date of the current node's equivalent field. For example, say you have a
"publication_date" field on your node, and you have a related_content view that
appears on this node. If you select the "relativity" configuration option, the
module will check the publication_date field in each result row and apply
scoring rules based on the difference between the date of the "publication_date"
in the row, and the date of the node that the view is displayed on.
* How much to penalize content based on the difference in date in the datetime fields.
