/**
 * @file
 * Views Share embed adjustments.
 */

(function (Drupal, drupalSettings, $, once) {
  Drupal.behaviors.viewsShareEmbed = {
    attach(context) {
      if (
        drupalSettings.viewsShareEmbed &&
        drupalSettings.viewsShareEmbed.rewriteLinks
      ) {
        once(
          'views-share-embed',
          'a:not(.views-share-embedded)',
          context,
        ).forEach(function (element) {
          $(element).attr('target', '_blank');
        });
      }
    },
  };
})(Drupal, drupalSettings, jQuery, once);
